# Iris.R  
# Correlation for Iris data

# Load necessary libraries
library(Hmisc)

# Read in data set
irisdata <- read.table(header=T,colClasses=c("numeric","numeric"),text="
seplen sepwid
5.1 3.5
4.9 3.0
4.7 3.2
4.6 3.1
5.0 3.6
5.4 3.9
4.6 3.4
5.0 3.4
4.4 2.9
4.9 3.1
")

# Print data
irisdata

# Scatterplot matrix
plot(irisdata)

# Pearson correlation coefficients
# Convert data frame to matrix using as.matrix
rp <- rcorr(as.matrix(irisdata))
print(rp$r,digits=5)
print(rp$P,digits=5)

# Spearman correlation coefficients
rs <- rcorr(as.matrix(irisdata),type="spearman")
print(rs$r,digits=5)
print(rs$P,digits=5)

